using System;
using System.Diagnostics;

namespace ConverterSamples
{
   class Program
   {
      private ConverterConnection _converterServer = null;


      /// <summary>
      /// Entry point
      /// </summary>
      /// <param name="args"></param>
      static void Main(string[] args)
      {
         Program program = new Program();
         program.Run(args);
      }

      /// <summary>
      /// Run the program with the following arguments:
      ///   converter server name or IP address
      ///   converter server username
      ///   converter server password
      ///   one or more properties files
      /// </summary>
      /// <param name="args"></param>
      void Run(string[] args)
      {
         if (args.Length < 4) {
            Console.Error.WriteLine("Missing command line arguments.");
            Console.Error.WriteLine("USAGE: ConverterSamples <converterServerAddress> " +
                                    "<userName> <password> <propertiesfile>...");
            return;
         }

         if (args[0].Equals("/?")) {
            Console.WriteLine("USAGE: ConverterSamples <converterServerAddress> " +
                              "<userName> <password> <propertiesfile>...");
            return;
         }

         _converterServer = new ConverterConnection();

         String address = "https://" + args[0] + "/converter/sdk";

         try {
            _converterServer.Connect(address, args[1], args[2]);
         } catch (Exception e) {
            System.Console.Error.WriteLine("Failed to Connect to Converter Server.");
            System.Console.Error.WriteLine(e.ToString());
            return;
         }

         for (int i = 3; i < args.Length; ++i) {
            ConverterOperation op = new ConverterOperation(_converterServer, args[i]);
            op.Execute();
         }
      }
   }
}
